import { useState } from "react";
import { useNavigate } from "react-router-dom";
import api from "../api/api";

export default function TrainingFormPage() {
  const [title, setTitle] = useState("");
  const [trainingDate, setTrainingDate] = useState("");
  const [vendor, setVendor] = useState("");
  const [cost, setCost] = useState(0);
  const [description, setDescription] = useState("");
  const [expectedResult, setExpectedResult] = useState("");
  const [purposes, setPurposes] = useState([]);
  const [error, setError] = useState("");
  const navigate = useNavigate();

  const togglePurpose = (value) => {
    setPurposes((prev) =>
      prev.includes(value)
        ? prev.filter((v) => v !== value)
        : [...prev, value]
    );
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setError("");

    try {
      await api.post("/training-requests", {
        title,
        description,
        training_date: trainingDate,
        vendor,
        cost: Number(cost),
        expected_result: expectedResult,
        purposes,
      });
      navigate("/");
    } catch (err) {
      setError(
        err.response?.data?.message ||
          "Gagal menyimpan pengajuan. Cek data yang diisi."
      );
    }
  };

  return (
    <div style={{ maxWidth: 600, margin: "20px auto" }}>
      <h2>Form Pengajuan Training</h2>
      <form onSubmit={handleSubmit}>
        <div>
          <label>Nama Training</label>
          <input
            value={title}
            onChange={(e) => setTitle(e.target.value)}
            style={{ width: "100%" }}
          />
        </div>

        <div>
          <label>Tanggal Training</label>
          <input
            type="date"
            value={trainingDate}
            onChange={(e) => setTrainingDate(e.target.value)}
          />
        </div>

        <div>
          <label>Penyelenggara</label>
          <input
            value={vendor}
            onChange={(e) => setVendor(e.target.value)}
            style={{ width: "100%" }}
          />
        </div>

        <div>
          <label>Biaya (Rp)</label>
          <input
            type="number"
            value={cost}
            onChange={(e) => setCost(e.target.value)}
          />
        </div>

        <div>
          <label>Tujuan Training</label>
          <div>
            <label>
              <input
                type="checkbox"
                checked={purposes.includes("skill")}
                onChange={() => togglePurpose("skill")}
              />
              Meningkatkan keterampilan
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                checked={purposes.includes("managerial")}
                onChange={() => togglePurpose("managerial")}
              />
              Meningkatkan pengetahuan manajerial
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                checked={purposes.includes("jobdesc")}
                onChange={() => togglePurpose("jobdesc")}
              />
              Memenuhi kriteria Job Description
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                checked={purposes.includes("refreshment")}
                onChange={() => togglePurpose("refreshment")}
              />
              Penyegaran / Refreshment
            </label>
          </div>
        </div>

        <div>
          <label>Deskripsi Tambahan</label>
          <textarea
            value={description}
            onChange={(e) => setDescription(e.target.value)}
            style={{ width: "100%" }}
          />
        </div>

        <div>
          <label>Hasil yang diharapkan</label>
          <textarea
            value={expectedResult}
            onChange={(e) => setExpectedResult(e.target.value)}
            style={{ width: "100%" }}
          />
        </div>

        {error && <div style={{ color: "red" }}>{error}</div>}

        <button type="submit">Simpan Pengajuan</button>
      </form>
    </div>
  );
}